#include <cmath>
#include <vector>
#include <iostream>
using namespace std;

struct Tacka
{
    float x;
    float y;
    Tacka() {
        x = 0.0;
        y = 0.0;
    }
    Tacka(float a, float b) {
        x = a;
        y = b;
    }
    float Rastojanje(Tacka t) {
        return sqrt((x - t.x) * (x - t.x) + (y - t.y) * (y - t.y));
    }
};
float Pertla(Tacka a, Tacka b, Tacka c) {
    return (a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - c.x * b.y - b.x * a.y);
}
struct Trougao
{
    Tacka a, b, c;
    Trougao() {

    }
    Trougao(Tacka t1, Tacka t2, Tacka t3) {
        a = t1;
        b = t2;
        c = t3;
    }
    bool Unutra(Tacka d) {
        if (Pertla(a, b, d) > 0 && Pertla(b, c, d) > 0 && Pertla(c, a, d) > 0) {
            return true;
        }
        else {
            return false;
        }
    }
};

int main()
{
    int n;
    cin >> n;
    vector<Tacka> a;
    for (int i = 0; i < n; i++) {
        float x, y;
        cin >>x>>y;
        a.push_back({ x,y });
    }
    float min = 2147483647;
    Trougao mint = Trougao();
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            for (int u = 0; u < n; u++) {
                if(a[i].Rastojanje(a[j])!=0 && a[i].Rastojanje(a[u]) != 0 && a[j].Rastojanje(a[u]) != 0)
                if (abs(Pertla(a[i], a[j], a[u]) / 2.0) < min) {
                    min = abs(Pertla(a[i], a[j], a[u]) / 2.0);
                    mint.a = a[i]; mint.b = a[j]; mint.c = a[u];
                }
            }
        }
    }
    cout << min;
}